﻿using RimWorld;
using System.Reflection;
using UnityEngine;
using Verse;
using Verse.AI;
using Object = System.Object;

namespace static_quality
{
    public class DetourInjector : SpecialInjector
    {
        public override bool Inject()
        {
            MethodInfo m1 = typeof(QualityUtility).GetMethod("RandomCreationQuality", BindingFlags.Static | BindingFlags.Public);
            MethodInfo m2 = typeof(_QualityUtility).GetMethod("_RandomCreationQuality", BindingFlags.Static | BindingFlags.Public);
            //            Log.Message("static_quality_Injector: Error");
            if (Detours.TryDetourFromTo(m1, m2))
            {
                Log.Message("static_quality_Injector: _QualityUtility _RandomCreationQuality injected successfully!");
                MethodInfo m3 = typeof(SkillRecord).GetMethod("Interval", BindingFlags.Instance | BindingFlags.Public);
                MethodInfo m4 = typeof(_SkillRecord_derived).GetMethod("_Interval", BindingFlags.Instance | BindingFlags.Public);

                //                Log.Message(typeof(SkillRecord).GetField("pawn", BindingFlags.Instance | BindingFlags.NonPublic).ToString());
                //              foreach (MethodInfo mx in typeof(static_quality_no_skill_degrading).GetMethods()) {
                //                 Log.Message(mx.ToString());
                //            }
                if (Detours.TryDetourFromTo(m3, m4))
                {
                    Log.Message("static_quality_Injector: _SkillRecord_derived _Interval injected successfully!");
                    MethodInfo m5 = typeof(SkillRecord).GetMethod("get_LearningSaturatedToday", BindingFlags.Instance | BindingFlags.Public);
                    MethodInfo m6 = typeof(_SkillRecord_derived).GetMethod("get__LearningSaturatedToday", BindingFlags.Instance | BindingFlags.Public);
                    if (Detours.TryDetourFromTo(m5, m6))
                    {
                        Log.Message("static_quality_Injector: _SkillRecord_derived _LearningSaturatedToday injected successfully!");
                        MethodInfo m7 = typeof(SkillRecord).GetMethod("Learn", BindingFlags.Instance | BindingFlags.Public);
                        MethodInfo m8 = typeof(_SkillRecord).GetMethod("_Learn", BindingFlags.Static | BindingFlags.Public);
                        if (Detours.TryDetourFromTo(m7, m8))
                        {
                            Log.Message("static_quality_Injector: _SkillRecord _Learn injected successfully!");
                            MethodInfo m9 = typeof(SkillUI).GetMethod("GetSkillDescription", BindingFlags.Static | BindingFlags.NonPublic);
                            MethodInfo m10 = typeof(_SkillUI).GetMethod("_GetSkillDescription", BindingFlags.Static | BindingFlags.NonPublic);
                            if (Detours.TryDetourFromTo(m9, m10))
                            {
                                Log.Message("static_quality_Injector: _SkillUI _GetSkillDescription injected successfully!");


                                GameObject initializer = new GameObject("MapComponentInjectorSQ");
                                initializer.AddComponent<MapComponentInjectorSQ>();
                                UnityEngine.Object.DontDestroyOnLoad(initializer);

                                return true;
                            }
                            else
                            {
                                return false;
                            }
                        }
                    }
                }
            }
            return false;
        }
    }
}